#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//BubbleSort in 2022Mod01.fsh   by   mrange 
//https://www.shadertoy.com/view/fd3BWM
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// License CC0: BubbleSort in 2022?
// I saw a tweet from hexler with some neat circle based shader
// Made a try to recreate it. Although not the same I think the result 
// turned out neat
// WRT bubblesort. I do a bubble sort to sort the the circle heights.
// I am open for better ideas!


#define TIME        iTime
#define RESOLUTION  iResolution
#define PI          3.141592654
#define TAU         (2.0*PI)
#define ROT(a)      mat2(cos(a), sin(a), -sin(a), cos(a))

// License: WTFPL, author: sam hocevar, found: https://stackoverflow.com/a/17897228/418488
const vec4 hsv2rgb_K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
vec3 hsv2rgb(vec3 c) {
  vec3 p = abs(fract(c.xxx + hsv2rgb_K.xyz) * 6.0 - hsv2rgb_K.www);
  return c.z * mix(hsv2rgb_K.xxx, clamp(p - hsv2rgb_K.xxx, 0.0, 1.0), c.y);
}
// License: WTFPL, author: sam hocevar, found: https://stackoverflow.com/a/17897228/418488
//  Macro version of above to enable compile-time constants
#define HSV2RGB(c)  (c.z * mix(hsv2rgb_K.xxx, clamp(abs(fract(c.xxx + hsv2rgb_K.xyz) * 6.0 - hsv2rgb_K.www) - hsv2rgb_K.xxx, 0.0, 1.0), c.y))


vec2 mod2_1(inout vec2 p) {
  p += 0.5;
  vec2 n = floor(p);
  p = fract(p)-0.5;
  return n;
}

// License: Unknown, author: Unknown, found: don't remember
vec2 hash(vec2 p) {
  p = vec2(dot (p, vec2 (127.1, 311.7)), dot (p, vec2 (269.5, 183.3)));
  return -1. + 2.*fract (sin (p)*43758.5453123);
}

// License: CC0, author: Mårten Rånge, found: https://github.com/mrange/glsl-snippets
vec3 alphaBlend(vec3 back, vec4 front) {
  // Based on: https://en.wikipedia.org/wiki/Alpha_compositing
  return mix(back, front.xyz, front.w);
}

// License: Unknown, author: Unknown, found: don't remember
float tanh_approx(float x) {
  //  Found this somewhere on the interwebs
  //  return tanh(x);
  float x2 = x*x;
  return clamp(x*(27.0 + x2)/(27.0+9.0*x2), -1.0, 1.0);
}

float cellhf(vec2 n) {
  float h = texture2D(texture0, 0.005*n+0.5).x; 
  h = sqrt(h);
  h = smoothstep(0.1, 0.85, h);
  return h;
}

float celldf(vec2 p, vec2 n) {
  vec2 h = hash(n);
  const float off = 0.25;
  p += off*h;
  float dd = length(p) - (sqrt(0.5)+off);
  return dd;
}

vec3 effect(vec2 p) {
  const float sz = 0.25;
  const float amp = 10.0;
  const float th = -TAU*sz*20.0;
  p += amp*cos(vec2(1.0, sqrt(0.5))*TAU*(TIME)/(amp*30.0));
  vec2 op = p;
  p /= sz;  
  float aa = 2.0/(sz*RESOLUTION.y);
  vec2 n = mod2_1(p);

  const int c = 1;
  const int l = (2*c+1)*(2*c+1);
  vec2 results[l];
  int j = 0;
  for (int x = -c; x <= c; ++x) {
    for (int y = -c; y <= c; ++y) {
      vec2 off = vec2(float(x), float(y));
      vec2 pp = p - off;
      vec2 nn = n + off;
      
      float d = celldf(pp, nn);
      float h = cellhf(nn);
      
      results[j] = vec2(d, h);
      ++j;
    }
  }

  // Bubble sort in 2022?
  for (int o = 1; o < l; ++o) {
    for (int i = o; i > 0; --i) {
      vec2 l = results[i-1];
      vec2 r = results[i];
      if (l.y > r.y) {
        results[i - 1] = r;
        results[i] = l;
      }
    }
  }

  vec3 col = vec3(0.0);
  for (int i = 0; i < l; ++i) {
      vec2 r = results[i];
      float d = r.x;
      float h = r.y;
      vec4 bcol0 = vec4(hsv2rgb(vec3(fract(0.05*length(op)),mix(0.125, 1.0, h), mix(0.25, 1.0, h))), 1.0);
      vec4 bcol1 = vec4(vec3(bcol0*bcol0*0.25), 0.5);
      vec4 bcol = mix(bcol0, bcol1, smoothstep(-th*aa, th*aa, sin(th*d)));
      float t = smoothstep(aa, -aa, d);
      vec4 ccol = bcol;
      ccol.w *= t;


      col *= mix(1.0, 0.25, exp(-10.0*max(d, 0.0)));
      col = alphaBlend(col, ccol);
  }
  return col;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
  vec2 q = fragCoord/RESOLUTION.xy;
  vec2 p = -1. + 2. * q;
  p.x *= RESOLUTION.x/RESOLUTION.y;
  vec3 col = effect(p);
  col = clamp(col, 0.0, 1.0);
  col *= smoothstep(0.0, 4.0, TIME);
  col = sqrt(col);
  fragColor = vec4(col, 1.);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

